/***********************************************************************/
/*    DI Function Block 1                                              */
/***********************************************************************/

BLOCK func4_DI_1_block
{
    TYPE    FUNCTION;
    NUMBER    9;
}

func4_DI_1_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func4_DI_1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]      }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_1_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DI]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func4_DI_1_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func4_DI_1_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func4_DI_1_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func4_DI_1_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func4_DI_1_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func4_DI_1_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func4_DI_1_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func4_DI_1_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func4_DI_1_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func4_DI_1_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        "DI-1 Tag";
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func4_DI_1_strategy                         LIKE VARIABLE    phys_strategy
{
}

func4_DI_1_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func4_DI_1_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_1_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_1_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func4_DI_1_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_1_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_1_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_1_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func4_DI_1_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: DI-1    Additional Parameter                       */
/*---------------------------------------------------------------------*/

VARIABLE func4_DI_1_out_value
{
    LABEL        [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF (func4_DI_1_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func4_DI_1_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF (func4_DI_1_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func4_DI_1_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_func4_DI_1
        }
    }
    HANDLING
        IF (func4_DI_1_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func4_DI_1_out_status_limit                 LIKE VARIABLE    func4_DI_1_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_1_out_status_quality)
    }
}

VARIABLE func4_DI_1_channel
{
    LABEL        [func_channel];
    HELP        [func_channel_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1;
        {1,    "Mod_In_D_1(TB)"              },
        {2,    "Mod_In_D_2(TB)"              },
        {3,    "Mod_In_D_3(TB)"              },
        {4,    "Mod_In_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_invert
{
    LABEL        [func_invert];
    HELP        [func_invert_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help_PROFILE_3];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        { 0,    [func_ai_fsafe_type_FAIL_SAFE_VALUE]        },
        { 1,    [func_ai_fsafe_type_STORING_LAST_SETPOINT]  },
        { 2,    [func_ai_fsafe_type_FAIL_SAFE_POSITION]     }
    }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_1_fsafe_value
{
   LABEL       [func_ai_fsafe_value] ;
   HELP        [func_ai_fsafe_value_help];
   CLASS       CONTAINED;
   TYPE        UNSIGNED_INTEGER (1)
   {
      DEFAULT_VALUE    0;
   }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_1_simulate_value
{
    LABEL        [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS        CONTAINED & SERVICE;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }   
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_1_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func4_DI_1
    }
    HANDLING    READ & WRITE;
}

func4_DI_1_simulate_status_limit            LIKE VARIABLE    func4_DI_1_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_1_simulate_status_quality)
    }
}

VARIABLE func4_DI_1_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING READ & WRITE;
}

/***********************************************************************/
/*    DI-1 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func4_DI_1_blk
{
    BLOCK func4_DI_1_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_blk_reserve,        func4_DI_1_blk_object,
            func4_DI_1_blk_parent_class,   func4_DI_1_blk_class,
            func4_DI_1_blk_dd_reference,   func4_DI_1_blk_dd_rev,
            func4_DI_1_blk_profile,        func4_DI_1_blk_profile_rev,
            func4_DI_1_blk_execution_time, func4_DI_1_blk_num_parameters,
            func4_DI_1_blk_index_view_1,   func4_DI_1_blk_num_view_lists
        }
    }
}

COMMAND read_func4_DI_1_st_rev
{
    BLOCK func4_DI_1_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_st_rev
        }
    }
}

COMMAND read_func4_DI_1_tag_desc
{
    BLOCK func4_DI_1_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_tag_desc
        }
    }
}

COMMAND write_func4_DI_1_tag_desc
{
    BLOCK func4_DI_1_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_strategy
{
    BLOCK func4_DI_1_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_strategy
        }
    }
}

COMMAND write_func4_DI_1_strategy
{
    BLOCK func4_DI_1_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_alert_key
{
    BLOCK func4_DI_1_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_alert_key
        }
    }
}

COMMAND write_func4_DI_1_alert_key
{
    BLOCK func4_DI_1_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_target_mode
{
    BLOCK func4_DI_1_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_target_mode
        }
    }
}

COMMAND write_func4_DI_1_target_mode
{
    BLOCK func4_DI_1_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_mode
{
    BLOCK func4_DI_1_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func4_DI_1_actual_mode, func4_DI_1_permitted_mode, func4_DI_1_normal_mode
        }
    }
}

COMMAND read_func4_DI_1_alarm
{
    BLOCK func4_DI_1_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_current_state_alarm_sum, func4_DI_1_unacknowledged_state_alarm_sum,
            func4_DI_1_unreported_state_alarm_sum, func4_DI_1_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func4_DI_1_batch_information
{
    BLOCK func4_DI_1_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_batch_id, func4_DI_1_batch_unit, func4_DI_1_batch_operation, func4_DI_1_batch_phase
        }
    }
}

COMMAND write_func4_DI_1_batch_information
{
    BLOCK func4_DI_1_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_batch_id, func4_DI_1_batch_unit, func4_DI_1_batch_operation, func4_DI_1_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_out
{
    BLOCK func4_DI_1_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_out_value,
            func4_DI_1_out_status_quality    <0xFC>,
            func4_DI_1_out_status_limit      <0x03>
        }
    }
}

COMMAND read_func4_DI_1_channel
{
    BLOCK func4_DI_1_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_channel
        }
    }
}

COMMAND write_func4_DI_1_channel
{
    BLOCK func4_DI_1_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_invert
{
    BLOCK func4_DI_1_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_invert
        }
    }
}

COMMAND write_func4_DI_1_invert
{
    BLOCK func4_DI_1_block;
    INDEX 15;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_fsafe_type
{
    BLOCK func4_DI_1_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_fsafe_type
        }
    }
}

COMMAND write_func4_DI_1_fsafe_type
{
    BLOCK func4_DI_1_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_fsafe_value
{
    BLOCK func4_DI_1_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_fsafe_value
        }
    }
}

COMMAND write_func4_DI_1_fsafe_value
{
    BLOCK func4_DI_1_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_1_simulate
{
    BLOCK func4_DI_1_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_1_simulate_status_quality    <0xFC>,
            func4_DI_1_simulate_status_limit      <0x03>,
            func4_DI_1_simulate_value,
            func4_DI_1_simulation_enabled
        }
    }
}

COMMAND write_func4_DI_1_simulate
{
    BLOCK func4_DI_1_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_1_simulate_status_quality    <0xFC>,
            func4_DI_1_simulate_status_limit      <0x03>,
            func4_DI_1_simulate_value,
            func4_DI_1_simulation_enabled
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DI-1 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func4_DI_1
{
    LABEL        "DI-1";
    ITEMS
    {
        func4_DI_1_st_rev,
        func4_DI_1_channel,
        func4_DI_1_invert,
        Tab_s_func4_DI_1_batch,
        Tab_s_func4_DI_1_fsafe
    }
}

MENU Tab_m_func4_DI_1
{
    LABEL        "DI-1";
    ITEMS
    {
        func4_DI_1_st_rev,
        func4_DI_1_channel    (READ_ONLY),
        func4_DI_1_invert     (READ_ONLY),
        Tab_s_func4_DI_1_batch,
        Tab_m_func4_DI_1_fsafe
    }
}

MENU Tab_s_func4_DI_1_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
            func4_DI_1_batch_id,
            func4_DI_1_batch_unit,
            func4_DI_1_batch_operation,
            func4_DI_1_batch_phase
    }
}

MENU Tab_s_func4_DI_1_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_1_fsafe_type,
        func4_DI_1_fsafe_value
    }
}

MENU Tab_m_func4_DI_1_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_1_fsafe_type     (READ_ONLY),
        func4_DI_1_fsafe_value    (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DI-1 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_out_func4_DI_1
{
    LABEL        "DI-1";
    ITEMS
    {
        Group_display_out_func4_DI_1,
        Group_display_input_func4_DI_1
    }
}

MENU Group_display_out_func4_DI_1
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_1_out_value                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_1_out_status_quality       (READ_ONLY),
        func4_DI_1_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_input_func4_DI_1
{
    LABEL        [MC_Input];
    ITEMS
    {
        func4_DI_1_channel                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_1_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func4_DI_1
{
    LABEL        "DI-1";
    ITEMS
    {
        Page_alarm_sum_func4_DI_1
    }
}

MENU Page_alarm_sum_func4_DI_1
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func4_DI_1_current_state_alarm_sum,
        func4_DI_1_unreported_state_alarm_sum
    }
}

MENU Page_diagnosis_func4_DI_1
{
    LABEL        "DI-1";
    ITEMS
    {
        func4_DI_1_blk_object,
        func4_DI_1_blk_parent_class,
        func4_DI_1_blk_class,
        func4_DI_1_blk_dd_reference,
        func4_DI_1_blk_dd_rev,
        func4_DI_1_blk_profile,
        func4_DI_1_blk_profile_rev,
        func4_DI_1_st_rev,
        func4_DI_1_actual_mode
    }
}

/*---------------------------------------------------------------------*/
/*    DI-1 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_DI_1_setting
{
    LABEL "DI-1 Block Mode";
    ITEMS
    {
        Page_func4_DI_1_mode
    }
}

MENU Page_func4_DI_1_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_DI_1_mode,
        Group_DI_1_out_value,
        func4_DI_1_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_DI_1_target_mode
    }
}

MENU Group_DI_1_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func4_DI_1_target_mode,
        COLUMNBREAK,
        func4_DI_1_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_DI_1_target_mode
    }
}

MENU Group_DI_1_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func4_DI_1_out_value,
        COLUMNBREAK,
        func4_DI_1_out_status_quality,
        func4_DI_1_out_status_limit
    }
}

MENU OnlineDialog_simulation_func4_DI_1
{
    LABEL        "Simulate DI-1";
    ITEMS
    {
        Page_simulation_input_func4_DI_1,
        Page_simulation_output_func4_DI_1
    }
}

MENU Page_simulation_input_func4_DI_1
{
    LABEL       [menu_dialog_simulation_input];
    ITEMS
    {
        func4_DI_1_simulation_enabled,
        Group_simulate_input_func4_DI_1,
        method_set
    }
}

MENU Group_simulate_input_func4_DI_1
{
    LABEL       [func_simulate_value];
    ITEMS
    {
        func4_DI_1_simulate_value,
        COLUMNBREAK,
        func4_DI_1_simulate_status_quality,
        func4_DI_1_simulate_status_limit
    }
}

MENU Page_simulation_output_func4_DI_1
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        func4_DI_1_target_mode,
        func4_DI_1_actual_mode,
        Group_simulate_output_func4_DI_1,
        method_set
    }
}

MENU Group_simulate_output_func4_DI_1
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_1_out_value,
        COLUMNBREAK,
        func4_DI_1_out_status_quality,
        func4_DI_1_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    DI-1 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DI_1_geral
{
    LABEL "DI-1";
    ITEMS
    {
        Page_DI_1_Basic_Settings,
        Page_DI_1_Advanced_Settings,
        Page_DI_1_Batch_Info
    }
}

MENU Page_DI_1_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_DI_1_Select_Input,
        Group_DI_1_Set_Invert_Input_Value
    }
}

MENU Group_DI_1_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func4_DI_1_channel,
        COLUMNBREAK,
        method_write_func4_DI_1_channel
    }
}

MENU Group_DI_1_Set_Invert_Input_Value
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func4_DI_1_invert,
        COLUMNBREAK,
        method_write_func4_DI_1_invert
    }
}

MENU Page_DI_1_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_DI_1_Set_Fail_Safe_Values
    }
}

MENU Group_DI_1_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func4_DI_1_fsafe_type,
        func4_DI_1_fsafe_value
        COLUMNBREAK,
        method_write_DI_1_set_fail_safe_values
    }
}

MENU Page_DI_1_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_DI_1_Define_Batch_Information
    }
}

MENU Group_DI_1_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func4_DI_1_batch_id,
        func4_DI_1_batch_unit,
        func4_DI_1_batch_operation,
        func4_DI_1_batch_phase
        COLUMNBREAK,
        method_write_func4_DI_1_batch_information
    }
}

/*---------------------------------------------------------------------*/
/*    DI-1 : Methods                                                   */
/*---------------------------------------------------------------------*/
METHOD method_DI_1_target_mode
{
    LABEL        "method target mode";
    DEFINITION
    {
        WriteCommand (write_func4_DI_1_target_mode);
    }
}

METHOD method_set_status_limit_func4_DI_1
{
    CLASS       INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func4_DI_1_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func4_DI_1_simulate_status_limit, 0);

        block_mode    = ivar_value(func4_DI_1_target_mode);
        quality        = ivar_value(func4_DI_1_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func4_DI_1_out_status_limit, 0);
    }
}
METHOD method_write_func4_DI_1_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_1_channel);
        ReadCommand(read_func4_DI_1_channel);
    }
}
METHOD method_write_func4_DI_1_invert
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_1_invert);
        ReadCommand(read_func4_DI_1_invert);
    }
}

METHOD method_write_DI_1_set_fail_safe_values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_1_fsafe_type);
        WriteCommand(write_func4_DI_1_fsafe_value);
        ReadCommand(read_func4_DI_1_fsafe_type);
        ReadCommand(read_func4_DI_1_fsafe_value);
    }
}

METHOD method_write_func4_DI_1_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_1_batch_information);
        ReadCommand(read_func4_DI_1_batch_information);
    }
}

/***********************************************************************/
/*    DI Function Block 2                                              */
/***********************************************************************/

BLOCK func4_DI_2_block
{
    TYPE    FUNCTION;
    NUMBER    10;
}

func4_DI_2_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func4_DI_2_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_2_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_2_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DI]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func4_DI_2_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func4_DI_2_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func4_DI_2_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func4_DI_2_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func4_DI_2_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func4_DI_2_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func4_DI_2_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func4_DI_2_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func4_DI_2_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func4_DI_2_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        "DI-2 Tag";
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func4_DI_2_strategy                         LIKE VARIABLE    phys_strategy
{
}

func4_DI_2_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func4_DI_2_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_2_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_2_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func4_DI_2_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_2_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_2_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_2_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func4_DI_2_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DI-2 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func4_DI_2_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF (func4_DI_2_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func4_DI_2_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF (func4_DI_2_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func4_DI_2_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_func4_DI_2
        }
    }
    HANDLING
        IF (func4_DI_2_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func4_DI_2_out_status_limit                 LIKE VARIABLE    func4_DI_2_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_2_out_status_quality)
    }
}

VARIABLE func4_DI_2_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   2;
        {1,    "Mod_In_D_1(TB)"              },
        {2,    "Mod_In_D_2(TB)"              },
        {3,    "Mod_In_D_3(TB)"              },
        {4,    "Mod_In_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help_PROFILE_3];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        { 0,    [func_ai_fsafe_type_FAIL_SAFE_VALUE]        },
        { 1,    [func_ai_fsafe_type_STORING_LAST_SETPOINT]  },
        { 2,    [func_ai_fsafe_type_FAIL_SAFE_POSITION]     }
    }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_2_fsafe_value
{
   LABEL       [func_ai_fsafe_value] ;
   HELP        [func_ai_fsafe_value_help];
   CLASS       CONTAINED;
   TYPE        UNSIGNED_INTEGER (1)
   {
      DEFAULT_VALUE    0;
   }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_2_simulate_value
{
    LABEL        [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS        CONTAINED & SERVICE;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }   
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_2_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func4_DI_2
    }
    HANDLING    READ & WRITE;
}

func4_DI_2_simulate_status_limit            LIKE VARIABLE    func4_DI_2_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_2_simulate_status_quality)
    }
}

VARIABLE func4_DI_2_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING READ & WRITE;
}

/***********************************************************************/
/*    DI-2 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func4_DI_2_blk
{
    BLOCK func4_DI_2_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_blk_reserve,        func4_DI_2_blk_object,
            func4_DI_2_blk_parent_class,   func4_DI_2_blk_class,
            func4_DI_2_blk_dd_reference,   func4_DI_2_blk_dd_rev,
            func4_DI_2_blk_profile,        func4_DI_2_blk_profile_rev,
            func4_DI_2_blk_execution_time, func4_DI_2_blk_num_parameters,
            func4_DI_2_blk_index_view_1,   func4_DI_2_blk_num_view_lists
        }
    }
}

COMMAND read_func4_DI_2_st_rev
{
    BLOCK func4_DI_2_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_st_rev
        }
    }
}

COMMAND read_func4_DI_2_tag_desc
{
    BLOCK func4_DI_2_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_tag_desc
        }
    }
}

COMMAND write_func4_DI_2_tag_desc
{
    BLOCK func4_DI_2_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_strategy
{
    BLOCK func4_DI_2_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_strategy
        }
    }
}

COMMAND write_func4_DI_2_strategy
{
    BLOCK func4_DI_2_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_alert_key
{
    BLOCK func4_DI_2_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_alert_key
        }
    }
}

COMMAND write_func4_DI_2_alert_key
{
    BLOCK func4_DI_2_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_target_mode
{
    BLOCK func4_DI_2_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_target_mode
        }
    }
}

COMMAND write_func4_DI_2_target_mode
{
    BLOCK func4_DI_2_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_mode
{
    BLOCK func4_DI_2_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func4_DI_2_actual_mode, func4_DI_2_permitted_mode, func4_DI_2_normal_mode
        }
    }
}

COMMAND read_func4_DI_2_alarm
{
    BLOCK func4_DI_2_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_current_state_alarm_sum, func4_DI_2_unacknowledged_state_alarm_sum,
            func4_DI_2_unreported_state_alarm_sum, func4_DI_2_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func4_DI_2_batch_information
{
    BLOCK func4_DI_2_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_batch_id, func4_DI_2_batch_unit, func4_DI_2_batch_operation, func4_DI_2_batch_phase
        }
    }
}

COMMAND write_func4_DI_2_batch_information
{
    BLOCK func4_DI_2_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_batch_id, func4_DI_2_batch_unit, func4_DI_2_batch_operation, func4_DI_2_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_out
{
    BLOCK func4_DI_2_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_out_value,
            func4_DI_2_out_status_quality    <0xFC>,
            func4_DI_2_out_status_limit      <0x03>
        }
    }
}

COMMAND read_func4_DI_2_channel
{
    BLOCK func4_DI_2_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_channel
        }
    }
}

COMMAND write_func4_DI_2_channel
{
    BLOCK func4_DI_2_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_invert
{
    BLOCK func4_DI_2_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_invert
        }
    }
}

COMMAND write_func4_DI_2_invert
{
    BLOCK func4_DI_2_block;
    INDEX 15;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_fsafe_type
{
    BLOCK func4_DI_2_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_fsafe_type
        }
    }
}

COMMAND write_func4_DI_2_fsafe_type
{
    BLOCK func4_DI_2_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_fsafe_value
{
    BLOCK func4_DI_2_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_fsafe_value
        }
    }
}

COMMAND write_func4_DI_2_fsafe_value
{
    BLOCK func4_DI_2_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_2_simulate
{
    BLOCK func4_DI_2_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_2_simulate_status_quality    <0xFC>,
            func4_DI_2_simulate_status_limit      <0x03>,
            func4_DI_2_simulate_value,
            func4_DI_2_simulation_enabled
        }
    }
}

COMMAND write_func4_DI_2_simulate
{
    BLOCK func4_DI_2_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_2_simulate_status_quality    <0xFC>,
            func4_DI_2_simulate_status_limit      <0x03>,
            func4_DI_2_simulate_value,
            func4_DI_2_simulation_enabled
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DI-2 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func4_DI_2
{
    LABEL        "DI-2";
    ITEMS
    {
        func4_DI_2_st_rev,
        func4_DI_2_channel,
        func4_DI_2_invert,
        Tab_s_func4_DI_2_batch,
        Tab_s_func4_DI_2_fsafe
    }
}

MENU Tab_m_func4_DI_2
{
    LABEL        "DI-2";
    ITEMS
    {
        func4_DI_2_st_rev,
        func4_DI_2_channel    (READ_ONLY),
        Tab_s_func4_DI_2_batch,
        Tab_m_func4_DI_2_fsafe
    }
}

MENU Tab_s_func4_DI_2_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
            func4_DI_2_batch_id,
            func4_DI_2_batch_unit,
            func4_DI_2_batch_operation,
            func4_DI_2_batch_phase
    }
}

MENU Tab_s_func4_DI_2_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_2_fsafe_type,
        func4_DI_2_fsafe_value
    }
}

MENU Tab_m_func4_DI_2_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_2_fsafe_type    (READ_ONLY),
        func4_DI_2_fsafe_value   (READ_ONLY)
    }
}

/***********************************************************************/
/*    Function Block : Online-Windows                                  */
/***********************************************************************/

MENU Page_display_out_func4_DI_2
{
    LABEL        "DI-2";
    ITEMS
    {
        Group_display_out_func4_DI_2,
        Group_display_input_func4_DI_2
    }
}

MENU Group_display_out_func4_DI_2
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_2_out_value                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_2_out_status_quality       (READ_ONLY),
        func4_DI_2_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_input_func4_DI_2
{
    LABEL        [MC_Input];
    ITEMS
    {
        func4_DI_2_channel                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_2_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func4_DI_2
{
    LABEL        "DI-2";
    ITEMS
    {
        Page_alarm_sum_func4_DI_2
    }
}

MENU Page_alarm_sum_func4_DI_2
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func4_DI_2_current_state_alarm_sum,
        func4_DI_2_unreported_state_alarm_sum
    }
}

MENU Page_diagnosis_func4_DI_2
{
    LABEL        "DI-2";
    ITEMS
    {
        func4_DI_2_blk_object,
        func4_DI_2_blk_parent_class,
        func4_DI_2_blk_class,
        func4_DI_2_blk_dd_reference,
        func4_DI_2_blk_dd_rev,
        func4_DI_2_blk_profile,
        func4_DI_2_blk_profile_rev,
        func4_DI_2_st_rev,
        func4_DI_2_actual_mode
    }
}

/*---------------------------------------------------------------------*/
/*    DI-2 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_DI_2_setting
{
    LABEL "DI-2 Block Mode";
    ITEMS
    {
        Page_func4_DI_2_mode
    }
}

MENU Page_func4_DI_2_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_DI_2_mode,
        Group_DI_2_out_value,
        func4_DI_2_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_DI_2_target_mode
    }
}

MENU Group_DI_2_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func4_DI_2_target_mode,
        COLUMNBREAK,
        func4_DI_2_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_DI_2_target_mode
    }
}

MENU Group_DI_2_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func4_DI_2_out_value,
        COLUMNBREAK,
        func4_DI_2_out_status_quality,
        func4_DI_2_out_status_limit
    }
}

MENU OnlineDialog_simulation_func4_DI_2
{
    LABEL        "Simulate DI-2";
    ITEMS
    {
        Page_simulation_input_func4_DI_2,
        Page_simulation_output_func4_DI_2
    }
}

MENU Page_simulation_input_func4_DI_2
{
    LABEL       [menu_dialog_simulation_input];
    ITEMS
    {
        func4_DI_2_simulation_enabled,
        Group_simulate_input_func4_DI_2,
        method_set
    }
}

MENU Group_simulate_input_func4_DI_2
{
    LABEL       [func_simulate_value];
    ITEMS
    {
        func4_DI_2_simulate_value,
        COLUMNBREAK,
        func4_DI_2_simulate_status_quality,
        func4_DI_2_simulate_status_limit
    }
}

MENU Page_simulation_output_func4_DI_2
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        func4_DI_2_target_mode,
        func4_DI_2_actual_mode,
        Group_simulate_output_func4_DI_2,
        method_set
    }
}

MENU Group_simulate_output_func4_DI_2
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_2_out_value,
        COLUMNBREAK,
        func4_DI_2_out_status_quality,
        func4_DI_2_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    DI-2 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DI_2_geral
{
    LABEL "DI-2";
    ITEMS
    {
        Page_DI_2_Basic_Settings,
        Page_DI_2_Advanced_Settings,
        Page_DI_2_Batch_Info
    }
}

MENU Page_DI_2_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_DI_2_Select_Input,
        Group_DI_2_Set_Invert_Input_Value
    }
}

MENU Group_DI_2_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func4_DI_2_channel,
        COLUMNBREAK,
        method_write_func4_DI_2_channel
    }
}

MENU Group_DI_2_Set_Invert_Input_Value
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func4_DI_2_invert,
        COLUMNBREAK,
        method_write_func4_DI_2_invert
    }
}

MENU Page_DI_2_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_DI_2_Set_Fail_Safe_Values
    }
}

MENU Group_DI_2_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func4_DI_2_fsafe_type,
        func4_DI_2_fsafe_value
        COLUMNBREAK,
        method_write_DI_2_set_fail_safe_values
    }
}

MENU Page_DI_2_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_DI_2_Define_Batch_Information
    }
}

MENU Group_DI_2_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func4_DI_2_batch_id,
        func4_DI_2_batch_unit,
        func4_DI_2_batch_operation,
        func4_DI_2_batch_phase
        COLUMNBREAK,
        method_write_func4_DI_2_batch_information
    }
}

/*---------------------------------------------------------------------*/
/*    DI-2 : Methods                                                   */
/*---------------------------------------------------------------------*/
METHOD method_DI_2_target_mode
{
    LABEL        "method target mode";
    DEFINITION
    {
        WriteCommand (write_func4_DI_2_target_mode);
    }
}

METHOD method_set_status_limit_func4_DI_2
{
    CLASS       INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func4_DI_2_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func4_DI_2_simulate_status_limit, 0);

        block_mode    = ivar_value(func4_DI_2_target_mode);
        quality        = ivar_value(func4_DI_2_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func4_DI_2_out_status_limit, 0);
    }
}

METHOD method_write_func4_DI_2_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_2_channel);
        ReadCommand(read_func4_DI_2_channel);
    }
}
METHOD method_write_func4_DI_2_invert
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_2_invert);
        ReadCommand(read_func4_DI_2_invert);
    }
}

METHOD method_write_DI_2_set_fail_safe_values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_2_fsafe_type);
        WriteCommand(write_func4_DI_2_fsafe_value);
        ReadCommand(read_func4_DI_2_fsafe_type);
        ReadCommand(read_func4_DI_2_fsafe_value);
    }
}

METHOD method_write_func4_DI_2_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_2_batch_information);
        ReadCommand(read_func4_DI_2_batch_information);
    }
}

/***********************************************************************/
/*    DI Function Block 3                                              */
/***********************************************************************/

BLOCK func4_DI_3_block
{
    TYPE    FUNCTION;
    NUMBER    11;
}

func4_DI_3_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func4_DI_3_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]      }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_3_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_3_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DI]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func4_DI_3_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func4_DI_3_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func4_DI_3_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func4_DI_3_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func4_DI_3_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func4_DI_3_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func4_DI_3_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func4_DI_3_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func4_DI_3_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func4_DI_3_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        "DI-3 Tag";
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func4_DI_3_strategy                         LIKE VARIABLE    phys_strategy
{
}

func4_DI_3_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func4_DI_3_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_3_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_3_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func4_DI_3_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_3_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_3_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_3_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func4_DI_3_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: DI-3    Additional Parameter                     */
/*---------------------------------------------------------------------*/

VARIABLE func4_DI_3_out_value
{
    LABEL        [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS        OUTPUT & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF (func4_DI_3_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func4_DI_3_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF (func4_DI_3_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func4_DI_3_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_func4_DI_3
        }
    }
    HANDLING
        IF (func4_DI_3_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func4_DI_3_out_status_limit                 LIKE VARIABLE    func4_DI_3_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_3_out_status_quality)
    }
}

VARIABLE func4_DI_3_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   3;
        {1,    "Mod_In_D_1(TB)"              },
        {2,    "Mod_In_D_2(TB)"              },
        {3,    "Mod_In_D_3(TB)"              },
        {4,    "Mod_In_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help_PROFILE_3];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        { 0,    [func_ai_fsafe_type_FAIL_SAFE_VALUE]        },
        { 1,    [func_ai_fsafe_type_STORING_LAST_SETPOINT]  },
        { 2,    [func_ai_fsafe_type_FAIL_SAFE_POSITION]     }
    }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_3_fsafe_value
{
   LABEL       [func_ai_fsafe_value] ;
   HELP        [func_ai_fsafe_value_help];
   CLASS       CONTAINED;
   TYPE        UNSIGNED_INTEGER (1)
   {
      DEFAULT_VALUE    0;
   }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_3_simulate_value
{
    LABEL        [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS        CONTAINED & SERVICE;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }   
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_3_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func4_DI_3
    }
    HANDLING    READ & WRITE;
}

func4_DI_3_simulate_status_limit            LIKE VARIABLE    func4_DI_3_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_3_simulate_status_quality)
    }
}

VARIABLE func4_DI_3_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING READ & WRITE;
}

/***********************************************************************/
/*    DI-3 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func4_DI_3_blk
{
    BLOCK func4_DI_3_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_blk_reserve,        func4_DI_3_blk_object,
            func4_DI_3_blk_parent_class,   func4_DI_3_blk_class,
            func4_DI_3_blk_dd_reference,   func4_DI_3_blk_dd_rev,
            func4_DI_3_blk_profile,        func4_DI_3_blk_profile_rev,
            func4_DI_3_blk_execution_time, func4_DI_3_blk_num_parameters,
            func4_DI_3_blk_index_view_1,   func4_DI_3_blk_num_view_lists
        }
    }
}

COMMAND read_func4_DI_3_st_rev
{
    BLOCK func4_DI_3_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_st_rev
        }
    }
}

COMMAND read_func4_DI_3_tag_desc
{
    BLOCK func4_DI_3_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_tag_desc
        }
    }
}

COMMAND write_func4_DI_3_tag_desc
{
    BLOCK func4_DI_3_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_strategy
{
    BLOCK func4_DI_3_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_strategy
        }
    }
}

COMMAND write_func4_DI_3_strategy
{
    BLOCK func4_DI_3_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_alert_key
{
    BLOCK func4_DI_3_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_alert_key
        }
    }
}

COMMAND write_func4_DI_3_alert_key
{
    BLOCK func4_DI_3_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_target_mode
{
    BLOCK func4_DI_3_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_target_mode
        }
    }
}

COMMAND write_func4_DI_3_target_mode
{
    BLOCK func4_DI_3_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_mode
{
    BLOCK func4_DI_3_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func4_DI_3_actual_mode, func4_DI_3_permitted_mode, func4_DI_3_normal_mode
        }
    }
}

COMMAND read_func4_DI_3_alarm
{
    BLOCK func4_DI_3_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_current_state_alarm_sum, func4_DI_3_unacknowledged_state_alarm_sum,
            func4_DI_3_unreported_state_alarm_sum, func4_DI_3_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func4_DI_3_batch_information
{
    BLOCK func4_DI_3_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_batch_id, func4_DI_3_batch_unit, func4_DI_3_batch_operation, func4_DI_3_batch_phase
        }
    }
}

COMMAND write_func4_DI_3_batch_information
{
    BLOCK func4_DI_3_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_batch_id, func4_DI_3_batch_unit, func4_DI_3_batch_operation, func4_DI_3_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_out
{
    BLOCK func4_DI_3_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_out_value,
            func4_DI_3_out_status_quality    <0xFC>,
            func4_DI_3_out_status_limit      <0x03>
        }
    }
}

COMMAND read_func4_DI_3_channel
{
    BLOCK func4_DI_3_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_channel
        }
    }
}

COMMAND write_func4_DI_3_channel
{
    BLOCK func4_DI_3_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_invert
{
    BLOCK func4_DI_3_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_invert
        }
    }
}

COMMAND write_func4_DI_3_invert
{
    BLOCK func4_DI_3_block;
    INDEX 15;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_fsafe_type
{
    BLOCK func4_DI_3_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_fsafe_type
        }
    }
}

COMMAND write_func4_DI_3_fsafe_type
{
    BLOCK func4_DI_3_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_fsafe_value
{
    BLOCK func4_DI_3_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_fsafe_value
        }
    }
}

COMMAND write_func4_DI_3_fsafe_value
{
    BLOCK func4_DI_3_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_3_simulate
{
    BLOCK func4_DI_3_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_3_simulate_status_quality    <0xFC>,
            func4_DI_3_simulate_status_limit      <0x03>,
            func4_DI_3_simulate_value,
            func4_DI_3_simulation_enabled
        }
    }
}

COMMAND write_func4_DI_3_simulate
{
    BLOCK func4_DI_3_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_3_simulate_status_quality    <0xFC>,
            func4_DI_3_simulate_status_limit      <0x03>,
            func4_DI_3_simulate_value,
            func4_DI_3_simulation_enabled
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DI-3 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func4_DI_3
{
    LABEL        "DI-3";
    ITEMS
    {
        func4_DI_3_st_rev,
        func4_DI_3_channel,
        func4_DI_3_invert,
        Tab_s_func4_DI_3_batch,
        Tab_s_func4_DI_3_fsafe
    }
}

MENU Tab_m_func4_DI_3
{
    LABEL        "DI-3";
    ITEMS
    {
        func4_DI_3_st_rev,
        func4_DI_3_channel    (READ_ONLY),
        func4_DI_3_invert     (READ_ONLY),
        Tab_s_func4_DI_3_batch,
        Tab_m_func4_DI_3_fsafe
    }
}

MENU Tab_s_func4_DI_3_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
            func4_DI_3_batch_id,
            func4_DI_3_batch_unit,
            func4_DI_3_batch_operation,
            func4_DI_3_batch_phase
    }
}

MENU Tab_s_func4_DI_3_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_3_fsafe_type,
        func4_DI_3_fsafe_value
    }
}

MENU Tab_m_func4_DI_3_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_3_fsafe_type     (READ_ONLY),
        func4_DI_3_fsafe_value    (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    DI-3 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_out_func4_DI_3
{
    LABEL        "DI-3";
    ITEMS
    {
        Group_display_out_func4_DI_3,
        Group_display_input_func4_DI_3
    }
}

MENU Group_display_out_func4_DI_3
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_3_out_value                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_3_out_status_quality       (READ_ONLY),
        func4_DI_3_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_input_func4_DI_3
{
    LABEL        [MC_Input];
    ITEMS
    {
        func4_DI_3_channel                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_3_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func4_DI_3
{
    LABEL        "DI-3";
    ITEMS
    {
        Page_alarm_sum_func4_DI_3
    }
}

MENU Page_alarm_sum_func4_DI_3
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func4_DI_3_current_state_alarm_sum,
        func4_DI_3_unreported_state_alarm_sum
    }
}

MENU Page_diagnosis_func4_DI_3
{
    LABEL        "DI-3";
    ITEMS
    {
        func4_DI_3_blk_object,
        func4_DI_3_blk_parent_class,
        func4_DI_3_blk_class,
        func4_DI_3_blk_dd_reference,
        func4_DI_3_blk_dd_rev,
        func4_DI_3_blk_profile,
        func4_DI_3_blk_profile_rev,
        func4_DI_3_st_rev,
        func4_DI_3_actual_mode
    }
}

/*---------------------------------------------------------------------*/
/*    DI-3 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_DI_3_setting
{
    LABEL "DI-3 Block Mode";
    ITEMS
    {
        Page_func4_DI_3_mode
    }
}

MENU Page_func4_DI_3_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_DI_3_mode,
        Group_DI_3_out_value,
        func4_DI_3_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_DI_3_target_mode
    }
}

MENU Group_DI_3_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func4_DI_3_target_mode,
        COLUMNBREAK,
        func4_DI_3_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_DI_3_target_mode
    }
}

MENU Group_DI_3_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func4_DI_3_out_value,
        COLUMNBREAK,
        func4_DI_3_out_status_quality,
        func4_DI_3_out_status_limit
    }
}

MENU OnlineDialog_simulation_func4_DI_3
{
    LABEL        "Simulate DI-3";
    ITEMS
    {
        Page_simulation_input_func4_DI_3,
        Page_simulation_output_func4_DI_3
    }
}

MENU Page_simulation_input_func4_DI_3
{
    LABEL       [menu_dialog_simulation_input];
    ITEMS
    {
        func4_DI_3_simulation_enabled,
        Group_simulate_input_func4_DI_3,
        method_set
    }
}

MENU Group_simulate_input_func4_DI_3
{
    LABEL       [func_simulate_value];
    ITEMS
    {
        func4_DI_3_simulate_value,
        COLUMNBREAK,
        func4_DI_3_simulate_status_quality,
        func4_DI_3_simulate_status_limit
    }
}

MENU Page_simulation_output_func4_DI_3
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        func4_DI_3_target_mode,
        func4_DI_3_actual_mode,
        Group_simulate_output_func4_DI_3,
        method_set
    }
}

MENU Group_simulate_output_func4_DI_3
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_3_out_value,
        COLUMNBREAK,
        func4_DI_3_out_status_quality,
        func4_DI_3_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    DI-3 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DI_3_geral
{
    LABEL "DI-3";
    ITEMS
    {
        Page_DI_3_Basic_Settings,
        Page_DI_3_Advanced_Settings,
        Page_DI_3_Batch_Info
    }
}

MENU Page_DI_3_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_DI_3_Select_Input,
        Group_DI_3_Set_Invert_Input_Value
    }
}

MENU Group_DI_3_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func4_DI_3_channel,
        COLUMNBREAK,
        method_write_func4_DI_3_channel
    }
}

MENU Group_DI_3_Set_Invert_Input_Value
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func4_DI_3_invert,
        COLUMNBREAK,
        method_write_func4_DI_3_invert
    }
}

MENU Page_DI_3_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_DI_3_Set_Fail_Safe_Values
    }
}

MENU Group_DI_3_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func4_DI_3_fsafe_type,
        func4_DI_3_fsafe_value
        COLUMNBREAK,
        method_write_DI_3_set_fail_safe_values
    }
}

MENU Page_DI_3_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_DI_3_Define_Batch_Information
    }
}

MENU Group_DI_3_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func4_DI_3_batch_id,
        func4_DI_3_batch_unit,
        func4_DI_3_batch_operation,
        func4_DI_3_batch_phase
        COLUMNBREAK,
        method_write_func4_DI_3_batch_information
    }
}

/*---------------------------------------------------------------------*/
/*    DI-3 : Methods                                                   */
/*---------------------------------------------------------------------*/
METHOD method_DI_3_target_mode
{
    LABEL        "method target mode";
    DEFINITION
    {
        WriteCommand (write_func4_DI_3_target_mode);
    }
}

METHOD method_set_status_limit_func4_DI_3
{
    CLASS       INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func4_DI_3_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func4_DI_3_simulate_status_limit, 0);

        block_mode    = ivar_value(func4_DI_3_target_mode);
        quality        = ivar_value(func4_DI_3_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func4_DI_3_out_status_limit, 0);
    }
}
METHOD method_write_func4_DI_3_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_3_channel);
        ReadCommand(read_func4_DI_3_channel);
    }
}
METHOD method_write_func4_DI_3_invert
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_3_invert);
        ReadCommand(read_func4_DI_3_invert);
    }
}

METHOD method_write_DI_3_set_fail_safe_values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_3_fsafe_type);
        WriteCommand(write_func4_DI_3_fsafe_value);
        ReadCommand(read_func4_DI_3_fsafe_type);
        ReadCommand(read_func4_DI_3_fsafe_value);
    }
}

METHOD method_write_func4_DI_3_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_3_batch_information);
        ReadCommand(read_func4_DI_3_batch_information);
    }
}

/***********************************************************************/
/*    DI Function Block 4                                              */
/***********************************************************************/

BLOCK func4_DI_4_block
{
    TYPE    FUNCTION;
    NUMBER    12;
}

func4_DI_4_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func4_DI_4_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_4_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_4_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,      [func_blk_class_DI]      },
        {    250,    [not_used]               },
        {    251,    [none]                   },
        {    252,    [unknown]                },
        {    253,    [special]                }
    }
    HANDLING    READ;
}

func4_DI_4_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func4_DI_4_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func4_DI_4_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func4_DI_4_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func4_DI_4_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func4_DI_4_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func4_DI_4_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func4_DI_4_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func4_DI_4_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func4_DI_4_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        "DI-4 Tag";
    TYPE                  ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func4_DI_4_strategy                         LIKE VARIABLE    phys_strategy
{
}

func4_DI_4_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func4_DI_4_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_4_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func4_DI_4_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func4_DI_4_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_4_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_4_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func4_DI_4_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func4_DI_4_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    DI-4 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func4_DI_4_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING
        IF (func4_DI_4_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

VARIABLE func4_DI_4_out_status_quality
{
    LABEL       [status_quality];
    HELP        [func_out_status_help];
    CLASS       OUTPUT & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        IF (func4_DI_4_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func4_DI_4_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_func4_DI_4
        }
    }
    HANDLING
        IF (func4_DI_4_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}

func4_DI_4_out_status_limit                 LIKE VARIABLE    func4_DI_4_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_4_out_status_quality)
    }
}

VARIABLE func4_DI_4_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   4;
        {1,    "Mod_In_D_1(TB)"              },
        {2,    "Mod_In_D_2(TB)"              },
        {3,    "Mod_In_D_3(TB)"              },
        {4,    "Mod_In_D_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_invert
{
    LABEL       [func_invert];
    HELP        [func_invert_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [func_invert_NOT_INVERT]    },
        {    1,    [func_invert_INVERT]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help_PROFILE_3];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        { 0,    [func_ai_fsafe_type_FAIL_SAFE_VALUE]        },
        { 1,    [func_ai_fsafe_type_STORING_LAST_SETPOINT]  },
        { 2,    [func_ai_fsafe_type_FAIL_SAFE_POSITION]     }
    }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_4_fsafe_value
{
   LABEL       [func_ai_fsafe_value] ;
   HELP        [func_ai_fsafe_value_help];
   CLASS       CONTAINED;
   TYPE        UNSIGNED_INTEGER (1)
   {
      DEFAULT_VALUE    0;
   }
   HANDLING        READ & WRITE;
}

VARIABLE func4_DI_4_simulate_value
{
    LABEL        [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS        CONTAINED & SERVICE;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0;
    }   
    HANDLING    READ & WRITE;
}

VARIABLE func4_DI_4_simulate_status_quality
{
    LABEL       [status_quality];
    HELP        [func_simulate_status_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func4_DI_4
    }
    HANDLING    READ & WRITE;
}

func4_DI_4_simulate_status_limit            LIKE VARIABLE    func4_DI_4_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func4_DI_4_simulate_status_quality)
    }
}

VARIABLE func4_DI_4_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING READ & WRITE;
}

/***********************************************************************/
/*    DI-4 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func4_DI_4_blk
{
    BLOCK func4_DI_4_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_blk_reserve,        func4_DI_4_blk_object,
            func4_DI_4_blk_parent_class,   func4_DI_4_blk_class,
            func4_DI_4_blk_dd_reference,   func4_DI_4_blk_dd_rev,
            func4_DI_4_blk_profile,        func4_DI_4_blk_profile_rev,
            func4_DI_4_blk_execution_time, func4_DI_4_blk_num_parameters,
            func4_DI_4_blk_index_view_1,   func4_DI_4_blk_num_view_lists
        }
    }
}

COMMAND read_func4_DI_4_st_rev
{
    BLOCK func4_DI_4_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_st_rev
        }
    }
}

COMMAND read_func4_DI_4_tag_desc
{
    BLOCK func4_DI_4_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_tag_desc
        }
    }
}

COMMAND write_func4_DI_4_tag_desc
{
    BLOCK func4_DI_4_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_strategy
{
    BLOCK func4_DI_4_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_strategy
        }
    }
}

COMMAND write_func4_DI_4_strategy
{
    BLOCK func4_DI_4_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_alert_key
{
    BLOCK func4_DI_4_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_alert_key
        }
    }
}

COMMAND write_func4_DI_4_alert_key
{
    BLOCK func4_DI_4_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_target_mode
{
    BLOCK func4_DI_4_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_target_mode
        }
    }
}

COMMAND write_func4_DI_4_target_mode
{
    BLOCK func4_DI_4_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_mode
{
    BLOCK func4_DI_4_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func4_DI_4_actual_mode, func4_DI_4_permitted_mode, func4_DI_4_normal_mode
        }
    }
}

COMMAND read_func4_DI_4_alarm
{
    BLOCK func4_DI_4_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_current_state_alarm_sum, func4_DI_4_unacknowledged_state_alarm_sum,
            func4_DI_4_unreported_state_alarm_sum, func4_DI_4_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func4_DI_4_batch_information
{
    BLOCK func4_DI_4_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_batch_id, func4_DI_4_batch_unit, func4_DI_4_batch_operation, func4_DI_4_batch_phase
        }
    }
}

COMMAND write_func4_DI_4_batch_information
{
    BLOCK func4_DI_4_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_batch_id, func4_DI_4_batch_unit, func4_DI_4_batch_operation, func4_DI_4_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_out
{
    BLOCK func4_DI_4_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_out_value,
            func4_DI_4_out_status_quality    <0xFC>,
            func4_DI_4_out_status_limit      <0x03>
        }
    }
}

COMMAND read_func4_DI_4_channel
{
    BLOCK func4_DI_4_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_channel
        }
    }
}

COMMAND write_func4_DI_4_channel
{
    BLOCK func4_DI_4_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_invert
{
    BLOCK func4_DI_4_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_invert
        }
    }
}

COMMAND write_func4_DI_4_invert
{
    BLOCK func4_DI_4_block;
    INDEX 15;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_invert
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_fsafe_type
{
    BLOCK func4_DI_4_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_fsafe_type
        }
    }
}

COMMAND write_func4_DI_4_fsafe_type
{
    BLOCK func4_DI_4_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_fsafe_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_fsafe_value
{
    BLOCK func4_DI_4_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_fsafe_value
        }
    }
}

COMMAND write_func4_DI_4_fsafe_value
{
    BLOCK func4_DI_4_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_fsafe_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func4_DI_4_simulate
{
    BLOCK func4_DI_4_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DI_4_simulate_status_quality    <0xFC>,
            func4_DI_4_simulate_status_limit      <0x03>,
            func4_DI_4_simulate_value,
            func4_DI_4_simulation_enabled
        }
    }
}

COMMAND write_func4_DI_4_simulate
{
    BLOCK func4_DI_4_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DI_4_simulate_status_quality    <0xFC>,
            func4_DI_4_simulate_status_limit      <0x03>,
            func4_DI_4_simulate_value,
            func4_DI_4_simulation_enabled
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    DI-4 : MENUs                                                     */
/***********************************************************************/

MENU Tab_s_func4_DI_4
{
    LABEL        "DI-4";
    ITEMS
    {
        func4_DI_4_st_rev,
        func4_DI_4_channel,
        func4_DI_4_invert,
        Tab_s_func4_DI_4_batch,
        Tab_s_func4_DI_4_fsafe
    }
}

MENU Tab_m_func4_DI_4
{
    LABEL        "DI-4";
    ITEMS
    {
        func4_DI_4_st_rev,
        func4_DI_4_channel    (READ_ONLY),
        Tab_s_func4_DI_4_batch,
        Tab_m_func4_DI_4_fsafe
    }
}

MENU Tab_s_func4_DI_4_batch
{
    LABEL       [menu_ident_batch_info];
    ITEMS
    {
            func4_DI_4_batch_id,
            func4_DI_4_batch_unit,
            func4_DI_4_batch_operation,
            func4_DI_4_batch_phase
    }
}

MENU Tab_s_func4_DI_4_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_4_fsafe_type,
        func4_DI_4_fsafe_value
    }
}

MENU Tab_m_func4_DI_4_fsafe
{
    LABEL       [menu_fail_safe] ;
    ITEMS
    {
        func4_DI_4_fsafe_type    (READ_ONLY),
        func4_DI_4_fsafe_value   (READ_ONLY)
    }
}

/***********************************************************************/
/*    Function Block : Online-Windows                                  */
/***********************************************************************/

MENU Page_display_out_func4_DI_4
{
    LABEL        "DI-4";
    ITEMS
    {
        Group_display_out_func4_DI_4,
        Group_display_input_func4_DI_4
    }
}

MENU Group_display_out_func4_DI_4
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_4_out_value                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_4_out_status_quality       (READ_ONLY),
        func4_DI_4_out_status_limit         (READ_ONLY)
    }
}

MENU Group_display_input_func4_DI_4
{
    LABEL        [MC_Input];
    ITEMS
    {
        func4_DI_4_channel                (READ_ONLY),
        COLUMNBREAK,
        func4_DI_4_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func4_DI_4
{
    LABEL        "DI-4";
    ITEMS
    {
        Page_alarm_sum_func4_DI_4
    }
}

MENU Page_alarm_sum_func4_DI_4
{
    LABEL       [menu_dialog_alarm_sum];
    ITEMS
    {
        func4_DI_4_current_state_alarm_sum,
        func4_DI_4_unreported_state_alarm_sum
    }
}

MENU Page_diagnosis_func4_DI_4
{
    LABEL        "DI-4";
    ITEMS
    {
        func4_DI_4_blk_object,
        func4_DI_4_blk_parent_class,
        func4_DI_4_blk_class,
        func4_DI_4_blk_dd_reference,
        func4_DI_4_blk_dd_rev,
        func4_DI_4_blk_profile,
        func4_DI_4_blk_profile_rev,
        func4_DI_4_st_rev,
        func4_DI_4_actual_mode
    }
}

/*---------------------------------------------------------------------*/
/*    DI-4 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_DI_4_setting
{
    LABEL "DI-4 Block Mode";
    ITEMS
    {
        Page_func4_DI_4_mode
    }
}

MENU Page_func4_DI_4_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_DI_4_mode,
        Group_DI_4_out_value,
        func4_DI_4_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_DI_4_target_mode
    }
}

MENU Group_DI_4_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func4_DI_4_target_mode,
        COLUMNBREAK,
        func4_DI_4_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_DI_4_target_mode
    }
}

MENU Group_DI_4_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func4_DI_4_out_value,
        COLUMNBREAK,
        func4_DI_4_out_status_quality,
        func4_DI_4_out_status_limit
    }
}

MENU OnlineDialog_simulation_func4_DI_4
{
    LABEL        "Simulate DI-4";
    ITEMS
    {
        Page_simulation_input_func4_DI_4,
        Page_simulation_output_func4_DI_4
    }
}

MENU Page_simulation_input_func4_DI_4
{
    LABEL       [menu_dialog_simulation_input];
    ITEMS
    {
        func4_DI_4_simulation_enabled,
        Group_simulate_input_func4_DI_4,
        method_set
    }
}

MENU Group_simulate_input_func4_DI_4
{
    LABEL       [func_simulate_value];
    ITEMS
    {
        func4_DI_4_simulate_value,
        COLUMNBREAK,
        func4_DI_4_simulate_status_quality,
        func4_DI_4_simulate_status_limit
    }
}

MENU Page_simulation_output_func4_DI_4
{
    LABEL       [menu_dialog_simulation_output];
    ITEMS
    {
        func4_DI_4_target_mode,
        func4_DI_4_actual_mode,
        Group_simulate_output_func4_DI_4,
        method_set
    }
}

MENU Group_simulate_output_func4_DI_4
{
    LABEL       [func_out_value];
    ITEMS
    {
        func4_DI_4_out_value,
        COLUMNBREAK,
        func4_DI_4_out_status_quality,
        func4_DI_4_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    DI-4 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_DI_4_geral
{
    LABEL "DI-4";
    ITEMS
    {
        Page_DI_4_Basic_Settings,
        Page_DI_4_Advanced_Settings,
        Page_DI_4_Batch_Info
    }
}

MENU Page_DI_4_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_DI_4_Select_Input,
        Group_DI_4_Set_Invert_Input_Value
    }
}

MENU Group_DI_4_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func4_DI_4_channel,
        COLUMNBREAK,
        method_write_func4_DI_4_channel
    }
}

MENU Group_DI_4_Set_Invert_Input_Value
{
    LABEL "Set Invert Input Value";
    ITEMS
    {
        func4_DI_4_invert,
        COLUMNBREAK,
        method_write_func4_DI_4_invert
    }
}

MENU Page_DI_4_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_DI_4_Set_Fail_Safe_Values
    }
}

MENU Group_DI_4_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func4_DI_4_fsafe_type,
        func4_DI_4_fsafe_value
        COLUMNBREAK,
        method_write_DI_4_set_fail_safe_values
    }
}

MENU Page_DI_4_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_DI_4_Define_Batch_Information
    }
}

MENU Group_DI_4_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func4_DI_4_batch_id,
        func4_DI_4_batch_unit,
        func4_DI_4_batch_operation,
        func4_DI_4_batch_phase
        COLUMNBREAK,
        method_write_func4_DI_4_batch_information
    }
}

/*---------------------------------------------------------------------*/
/*    DI-4 : Methods                                                   */
/*---------------------------------------------------------------------*/
METHOD method_DI_4_target_mode
{
    LABEL        "method target mode";
    DEFINITION
    {
        WriteCommand (write_func4_DI_4_target_mode);
    }
}

METHOD method_set_status_limit_func4_DI_4
{
    CLASS       INPUT;
    LABEL       "set status limit";
    DEFINITION
    {
        int    quality;
        int block_mode;

        quality = ivar_value(func4_DI_4_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func4_DI_4_simulate_status_limit, 0);

        block_mode    = ivar_value(func4_DI_4_target_mode);
        quality        = ivar_value(func4_DI_4_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func4_DI_4_out_status_limit, 0);
    }
}

METHOD method_write_func4_DI_4_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_4_channel);
        ReadCommand(read_func4_DI_4_channel);
    }
}
METHOD method_write_func4_DI_4_invert
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_4_invert);
        ReadCommand(read_func4_DI_4_invert);
    }
}

METHOD method_write_DI_4_set_fail_safe_values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_4_fsafe_type);
        WriteCommand(write_func4_DI_4_fsafe_value);
        ReadCommand(read_func4_DI_4_fsafe_type);
        ReadCommand(read_func4_DI_4_fsafe_value);
    }
}

METHOD method_write_func4_DI_4_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func4_DI_4_batch_information);
        ReadCommand(read_func4_DI_4_batch_information);
    }
}

/*   */

MENU Menu_DI_off
{
    LABEL "Discrete Input";
    ITEMS
    {
        OfflineWindow_DI_1_geral,
        OfflineWindow_DI_2_geral,
        OfflineWindow_DI_3_geral,
        OfflineWindow_DI_4_geral
    }
}

MENU Menu_DI_on
{
    LABEL "Discrete Input";
    ITEMS
    {
        OnlineDialog_DI_1_setting,
        OnlineDialog_DI_2_setting,
        OnlineDialog_DI_3_setting,
        OnlineDialog_DI_4_setting
    }
}

MENU Menu_simulate_DI
{
    LABEL "Simulate-DI";
    ITEMS
    {
        OnlineDialog_simulation_func4_DI_1,
        OnlineDialog_simulation_func4_DI_2,
        OnlineDialog_simulation_func4_DI_3,
        OnlineDialog_simulation_func4_DI_4
    }
}
